﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.ZUS" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    protected void dc_ContextLoad(object sender, EventArgs e) {
        DRA dra = (DRA)dc[typeof(DRA)];
        RCA rca = null;
        foreach (Deklaracja deklaracja in dra.Deklaracje) 
        if (deklaracja is RCA) {
            rca = (RCA)deklaracja;
            break;
        }

        if (rca == null)
            Grid1.DataSource = new RCA_O[] { };
        else
            Grid1.DataSource = rca.Deklaracje;
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        RCA_O rcao = (RCA_O)args.Row;
        BlokDeklaracji blok = rcao.Bloki["DDORCA"];
        int tyub = (int)blok["Tyub"];
        if ((tyub / 10000) != 12)
            args.VisibleRow = false;
        else {
            colTyub.EditValue = new TytulUbezpieczenia(tyub).ToString();
            colZusPodstawa.EditValue = (decimal)blok["PodstER"];
            colEmerytalna.EditValue = (decimal)blok["EmerBp"];
            colRentowa.EditValue = (decimal)blok["RentBp"];
            colZdrowotnaPodstawa.EditValue = (decimal)blok["PodstZ"];
            colZdrowotna.EditValue = (decimal)blok["ZdrowBp"];
        }
    }
    
    public static void Msg(object obj) {
    }

</script>

<HTML>
	<HEAD>
		<TITLE>Deklaracja</TITLE>
		<META http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" TypeName="Soneta.Deklaracje.ZUS.DRA,Soneta.Deklaracje" style="top: 0px" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="Zestawienie składek naliczanych za budżet państwa|</strong>Numer: <strong>{0}|</strong>Za miesiąc: <strong>{1:s}"
				DataMember0="Ident" DataMember1="RokMiesiac"></eb:ReportHeader>
				<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Deklaracje.ZUS.RCA_O,Soneta.Deklaracje" OnBeforeRow="Grid1_BeforeRow">
					<Columns>
                        <ea:GridColumn runat="server" Caption="Lp" DataMember="#" Width="4">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Pracownik" DataMember="Podmiot" Width="40">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Tytuł ubezpieczenia" ID="colTyub" Align="Center" Width="12">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Składki ZUS~podstawa" Align="Right" Format="{0:n}" ID="colZusPodstawa" HideZero="True">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Składki ZUS~emerytalna" Align="Right" Format="{0:n}" ID="colEmerytalna" Total="Sum" HideZero="True">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Składki ZUS~rentowa" Align="Right" Format="{0:n}" ID="colRentowa" Total="Sum" HideZero="True">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Składka zdrowotna~podstawa" Align="Right" Format="{0:n}" ID="colZdrowotnaPodstawa" HideZero="True">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Składka zdrowotna~składka" Align="Right" Format="{0:n}" ID="colZdrowotna" Total="Sum" HideZero="True">
                        </ea:GridColumn>
					</Columns>
				</ea:Grid>
				<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
